<?php
/* --------------------------------------------------------------
  HtmlTemplateLoader.inc.php 2019-06-07
  Gambio GmbH
  http://www.gambio.de
  Copyright (c) 2019 Gambio GmbH
  Released under the GNU General Public License (Version 2)
  [http://www.gnu.org/licenses/gpl-2.0.html]
  --------------------------------------------------------------*/

namespace StyleEdit; 

/**
 * Class HtmlTemplateLoader
 *
 * This class will load all the contents of the Mustache templates and output them altogether.
 *
 * @package StyleEdit
 */
class HtmlTemplateLoader
{
	/**
	 * @var string
	 */
	protected $templatePath;
	
	
	/**
	 * HtmlTemplateLoader Constructor
	 *
	 * @param string $p_templatePath
	 * 
	 * @throws \InvalidArgumentException if $p_templatePath is not a string
	 * @throws \UnexpectedValueException if $p_templatePath does not exists or is not a directory
	 */
	public function __construct($p_templatePath)
	{
		if(!is_string($p_templatePath))
		{
			throw new \InvalidArgumentException('Invalid argument provided (expected string got "'
			                                   . gettype($p_templatePath) . '"): ' . $p_templatePath);
		}
		
		if(!file_exists($p_templatePath) || !is_dir($p_templatePath))
		{
			throw new \UnexpectedValueException('The provided template path does not exist or is not a directory: '
			                                   . $p_templatePath);
		}
		
		$this->templatePath = rtrim($p_templatePath, '/');
	}
	
	
	/**
	 * Get templates as HTML string.
	 *
	 * @return string Returns all the template contents.
	 */
	public function asHtml()
	{
		$html = '';
		
		foreach(glob($this->templatePath . '/*.mustache') as $filepath)
		{
			$html .= file_get_contents($filepath);
		}
		
		return $html;
	}
}